//
//  KeyCell.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 17.02.23.
//

import UIKit

// https://www.youtube.com/watch?v=vI7m5RTYNng
class KeyCell: UICollectionViewCell {
    
    let digitsLabel = UILabel()
    
    
    //fileprivate let defaultCellBackgroundColor =
    
    override var isHighlighted: Bool {
        didSet {
            print("Highlighted Cell:", isHighlighted)
            
            UIView.animate(withDuration: 0.25) {
                self.backgroundColor = self.isHighlighted ? UIColor(white: 1, alpha: 0.7) : UIColor.clear
                
                self.digitsLabel.textColor = self.isHighlighted ? .white : .white
            }
            
            
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        // cell's background color
        backgroundColor = UIColor.clear
        
        // digits size and numbers
        digitsLabel.text = "8"
        digitsLabel.font = UIDevice.current.screenType == .iPhones_5_5s_5c_SE ? .systemFont(ofSize: 24, weight: .light) : .systemFont(ofSize: 32, weight: .light) // UIFont
        // number text color
        digitsLabel.textColor = UIColor.white //UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1)
        
        digitsLabel.textAlignment = .center
        
        let stackView = UIStackView(arrangedSubviews: [digitsLabel])
        stackView.axis = .vertical
        
        addSubview(stackView)
        stackView.centerInSuperview()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        layer.cornerRadius = self.frame.width / 2
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

// https://gist.github.com/vasilevkin/025a6257e513f453376514887c44b69f
// https://www.ios-resolution.com/
// https://stackoverflow.com/questions/26028918/how-to-determine-the-current-iphone-device-model
extension UIDevice {
    var iPhoneX: Bool {
        return UIScreen.main.nativeBounds.height == 2436
    }
    var iPhone: Bool {
        return UIDevice.current.userInterfaceIdiom == .phone
    }
    enum ScreenType: String {
        case iPhones_4_4S = "iPhone 4 or iPhone 4S"
        case iPhones_5_5s_5c_SE = "iPhone 5, iPhone 5s, iPhone 5c or iPhone SE"
        case iPhones_6_6s_7_8 = "iPhone 6, iPhone 6S, iPhone 7 or iPhone 8"
        case iPhones_6Plus_6sPlus_7Plus_8Plus = "iPhone 6 Plus, iPhone 6S Plus, iPhone 7 Plus or iPhone 8 Plus"
        case iPhones_X_XS = "iPhone X or iPhone XS"
        case iPhone_XR_11 = "iPhone XR, iPhone 11"
        case iPhone_XSMax = "iPhone XS Max"
        case iPhone_11 = "iPhone 11"
        case unknown
    }
    
    /*
     iPhone11           = "iPhone 11",
    iPhone11Pro        = "iPhone 11 Pro",
    iPhone11ProMax     = "iPhone 11 Pro Max",
    iPhoneSE2          = "iPhone SE 2nd gen",
    iPhone12Mini       = "iPhone 12 Mini",
    iPhone12           = "iPhone 12",
    iPhone12Pro        = "iPhone 12 Pro",
    iPhone12ProMax     = "iPhone 12 Pro Max",
    iPhone13Mini       = "iPhone 13 Mini",
    iPhone13           = "iPhone 13",
    iPhone13Pro        = "iPhone 13 Pro",
    iPhone13ProMax     = "iPhone 13 Pro Max",
    iPhoneSE3          = "iPhone SE 3nd gen",
    iPhone14           = "iPhone 14",
    iPhone14Plus       = "iPhone 14 Plus",
    iPhone14Pro        = "iPhone 14 Pro",
    iPhone14ProMax     = "iPhone 14 Pro Max"
    */
    
    var screenType: ScreenType {
        switch UIScreen.main.nativeBounds.height {
        case 960:
            return .iPhones_4_4S
        case 1136:
            return .iPhones_5_5s_5c_SE
        case 1334:
            return .iPhones_6_6s_7_8
        case 1792:
            return .iPhone_XR_11
        case 1920, 2208:
            return .iPhones_6Plus_6sPlus_7Plus_8Plus
        case 2436:
            return .iPhones_X_XS
        case 2688:
            return .iPhone_XSMax
        default:
            return .unknown
        }
    }
}
